/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.goals.actions;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.BaseGoal;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class BuildAroundTargetGoal
extends BaseGoal {
    private Block block = null;
    private int tickRate = 40;
    private int currentTick = 0;
    private int range = 2;
    private boolean enclose = false;

    public BuildAroundTargetGoal(BaseCreatureEntity setHost) {
        super(setHost);
    }

    public BuildAroundTargetGoal setBlock(Block block) {
        this.block = block;
        return this;
    }

    public BuildAroundTargetGoal setTickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public BuildAroundTargetGoal setRange(int range) {
        this.range = range;
        return this;
    }

    public BuildAroundTargetGoal setEnclose(boolean enclose) {
        this.enclose = enclose;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        return this.block == null || this.getTarget() != null;
    }

    public void func_75249_e() {
        this.currentTick = 0;
    }

    public void func_75246_d() {
        IBlockState blockState;
        BlockPos blockPos;
        int z;
        int x;
        if (this.currentTick++ < this.tickRate) {
            return;
        }
        this.currentTick = 0;
        int range = this.range;
        int enclosement = 0;
        BlockPos targetPos = this.getTarget().func_180425_c();
        if (this.enclose) {
            int smallestRange = range;
            for (x = -range; x <= range; ++x) {
                for (z = -range; z <= range; ++z) {
                    blockPos = targetPos.func_177982_a(x, 0, z);
                    blockState = this.host.func_130014_f_().func_180495_p(blockPos);
                    if (blockState.func_177230_c() != this.block) continue;
                    smallestRange = Math.min(Math.max(Math.abs(x), Math.abs(z)), smallestRange);
                }
            }
            enclosement = range - (range + 1 - smallestRange);
        }
        for (int currentRange = range; currentRange >= enclosement; --currentRange) {
            for (x = -currentRange; x <= currentRange; ++x) {
                for (z = -currentRange; z <= currentRange; ++z) {
                    if (Math.abs(x) != currentRange && Math.abs(z) != currentRange) continue;
                    blockPos = targetPos.func_177982_a(x, 0, z);
                    blockState = this.host.func_130014_f_().func_180495_p(blockPos);
                    if (blockState.func_177230_c() != Blocks.field_150350_a && blockState.func_177230_c() != this.block) continue;
                    this.host.func_130014_f_().func_175656_a(blockPos, this.block.func_176223_P());
                }
            }
        }
        this.host.triggerAttackCooldown();
        this.host.playAttackSound();
    }
}

